package de.bebagoe.figuren;

public class Kreis extends Figur {
    protected double radius;

    public Kreis(double x, double y, double rad) {
        if (x < 0 || y < 0 || rad < 0)
            throw new IllegalArgumentException("Kreis part. außerhalb oder Radius < 0");
        radius = rad;
        super(x, y);
    }

    public Kreis() {
        radius = 50.0;
        super();
    }

    public double getRadius() { return radius; }

    public double abstand(double x, double y) {
        return Math.sqrt(Math.pow(xpos + radius - x, 2) + Math.pow(ypos + radius - y, 2));
    }

    @Override
    public void wo() {
        super.wo();
        System.out.println("Unten rechts: (" + (xpos + 2 * radius) +
                ", " + (ypos + 2 * radius) + ")");
    }

    @Override
    public double meldeInhalt() {
        return Math.PI * radius*radius;
    }
}